# Essential Stuff

## Html import links

Google font

``` html
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@400;500;600;700;800&display=swap" rel="stylesheet">
```

Ionicon

``` html
<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
```

---

## Colors

``` css
--hoockers-green_20: hsl(148, 20%, 38%, 0.2);
--pale-spring-bud: hsl(60, 68%, 85%);
--hoockers-green: hsl(148, 20%, 38%);
--spanish-gray: hsl(0, 0%, 61%);
--light-gray: hsl(0, 0%, 80%);
--cultured-1: hsl(0, 0%, 97%);
--cultured-2: hsl(60, 6%, 93%);
--gray-web: hsl(0, 0%, 49%);
--white_30: hsl(0, 0%, 100%, 0.3);
--black_70: hsla(0, 0%, 0%, 0.7);
--black_50: hsla(0, 0%, 0%, 0.5);
--black_15: hsla(0, 0%, 0%, 0.15);
--black_10: hsla(0, 0%, 0%, 0.1);
--black_5: hsla(0, 0%, 0%, 0.05);
--white: hsl(0, 0%, 100%);
--black: hsl(0, 0%, 0%);
```

## Gradient color

``` css
--gradient: linear-gradient(to right, transparent 50%, var(--white_30) 100%);
```

## Typography

``` css
--ff-urbanist: 'Urbanist', sans-serif;

--fs-1: 4.8rem;
--fs-2: 4rem;
--fs-3: 3.4rem;
--fs-4: 2.4rem;
--fs-5: 2rem;
--fs-6: 1.8rem;
--fs-7: 1.5rem;
--fs-8: 1.4rem;
--fs-9: 1.3rem;

--fw-400: 400;
--fw-500: 500;
--fw-600: 600;
--fw-700: 700;
--fw-800: 800;
```

## Spacing

``` css
--section-padding: 35px;
```

## Shadow

``` css
--shadow-1: 0 8px 16px var(--black_15);
--shadow-2: 0 4px 10px var(--black_5);
```

## Border Radius

``` css
--radius-3: 3px;
```

## Transition

``` css
--transition-1: 0.25s ease;
--transition-2: 0.5s ease;
--cubic-in: cubic-bezier(0.51, 0.03, 0.64, 0.28);
--cubic-out: cubic-bezier(0.33, 0.85, 0.4, 0.96);
```
